/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.security.auth.realm;

import java.security.Principal;

import java.util.Enumeration;


/**
 * All users are principals ... perhaps in the native OS, perhaps
 * not.
 *
 * <P> Users always have authentication information, which is used
 * to validate a user's proferred credentials.  Different kinds of
 * realms use different kinds of authentication information.  For
 * example, realms could use X.509 public key certificates, shared
 * passphrases, encrypted passwords, smart cards, or biometric data
 * to figure out if the user's credentials are valid.
 * 
 * <P> Users typically have attributes that identify privileges 
 * granted/possesed by the user.
 *
 * @author Harish Prabandham
 */

public interface User extends Principal {
    /**
     * Returns the realm with which this user is associated.
     */
    Realm getRealm () throws NoSuchRealmException;


    /**
     * Returns the single requested attribute for the user.
     *
     * @param name string identifying the attribute.
     * @return value of that attribute, or null if no value
     *	has been defined
     */
    Object getAttribute (String name);


    /**
     * Returns an enumeration of the keys for the attributes
     * supported for this user.
     */
    Enumeration	getAttributeNames ();
}
