/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * @(#) AbstractMonitor.java
 *
 * Copyright 2000-2001 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of iPlanet/Sun Microsystems, Inc. ("Confidential Information").
 * You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license
 * agreement you entered into with iPlanet/Sun Microsystems.
 */
package com.sun.enterprise.server;

import java.util.HashSet;
import java.util.TimerTask;
import java.util.Timer;

/**
 * Base class for all monitors. It provides functionality to perform 
 * repeated tasks from server runtime.
 *
 * @atuthor Nazrul Islam
 * @since   JDK 1.4
 */
abstract class AbstractMonitor extends TimerTask {

    /** contains all the monitored entries */
    protected HashSet _monitoredEntries;

    /** timer to run this task */
    protected Timer _timer;

    /** polling interval for the timer */
    protected long _pollInterval; 

    /**
     * Constructor.
     *
     * @param    pollInterval    polling interval
     */
    AbstractMonitor(long pollInterval) {
        this._pollInterval      = pollInterval;
        this._monitoredEntries  = new HashSet();
    }

    /**
     * Starts this monitor. 
     */
    void start() {
        this._timer = new Timer(true);
        this._timer.schedule(this, 0, this._pollInterval);
    }

    /**
     * Stops this monitor. 
     */
    void stop() {
        if (this._timer != null) {
            this._timer.cancel();
        }
    }

    /**
     * Adds the given monitorable entry to the list. 
     * 
     * @param    entry    a monitorable entry
     */
    void addMonitorableEntry(MonitorableEntry entry) {

        synchronized (this._monitoredEntries) {
            this._monitoredEntries.add(entry);
        }
    }

    /**
     * Removes the monitorable entry from the list.
     *
     * @param    entry   monitorable entry to be removed
     */
    void removeMonitorableEntry(MonitorableEntry entry) {

        synchronized (this._monitoredEntries) {
            this._monitoredEntries.remove(entry);
        }
    }
}
