/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.server.event;

/**
 *Listener interface to receive app client load/unload events.
 * @author tjquinn
 */
public interface ApplicationClientLoaderEventListener {
    /**
     * This method is invoked whenever an App client is loaded/unloaded
     *
     *	ApplicationClientEvent.getEventType() specifies the exact
     *	application client event. Note that, this method is called
     *	even for stand alone modules. 
     *	ApplicationClientEvent.getApplication().isVirtual() will be
     *	true for stand-alone module and false otherwise.
     *
     * Generally, APPLICATION_CLIENT events are sent in the following order
     *  a) BEFORE_APPLICATION_CLIENT_LOAD
     *  b) AFTER_APPLICATION_CLIENT_LOAD
     *  c) BEFORE_APPLICATION_CLIENT_UNLOAD
     *  d) AFTER_APPLICATION_CLIENT_UNLOAD
     *  
     */
    public void handleApplicationClientEvent(ApplicationClientEvent event);
    
}
