/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * @(#) ApplicationLoaderEventListener.java
 *
 * Copyright 2000-2001 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of iPlanet/Sun Microsystems, Inc. ("Confidential Information").
 * You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license
 * agreement you entered into with iPlanet/Sun Microsystems.
 */
package com.sun.enterprise.server.event;

/**
 * Listener to receive Allication and EjbContainer events.
 */
public interface ApplicationLoaderEventListener {

    /**
     * This method is invoked whenever an App is loaded/unloaded
     *
     *	ApplicationEvent.getEventType() specifies the exact
     *	application event. Note that, this method is called
     *	event for stand alone modules. 
     *	ApplicationEvent.getApplication().isVirtual() will be
     *	true for stand-alone module and false otherwise.
     *
     * Generally, APPLICATION events are sent in the following order
     *  a) BEFORE_APPLICATION_LOADED
     *  b) AFTER_APPLICATION_LOADED
     *  c) BEFORE_APPLICATION_UNLOADED
     *  d) AFTER_APPLICATION_UNLOADED
     *
     * Note:-
     *  There are some cases, when AFTER_APPLICATION_LOADED and 
     *  BEFORE_APPLICATION_UNLOAD will not be sent to listeners. 
     *  In particular, if an Ejb cannot be loaded successfully
     *  then no AFTER_APPLICATION_LOADED and BEFORE_APPLICATION_UNLOAD
     *  will be sent to the listeners.
     *  
     */
    public void handleApplicationEvent(ApplicationEvent event);

    /**
     * This method is invoked whenever an EjbContainer is loaded/unloaded
     *
     *	EjbContainerEvent.getEventType() specifies the exact
     *	EjbContainer event. Note that, this method is called
     *	event for stand alone modules. 
     *	EjbContainerEvent.getApplication().isVirtual() will be
     *	true for stand-alone module and false otherwise.
     *
     * Generally, EjbContainer Events are sent in the following order
     *  a) BEFORE_EJB_CONTAINER_LOADED
     *  b) AFTER_EJB_CONTAINER_LOADED
     *  c) BEFORE_EJB_CONTAINER_UNLOADED
     *  d) AFTER_EJB_CONTAINER_UNLOADED
     *
     */
    public void handleEjbContainerEvent(EjbContainerEvent event);

}
