/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.server.logging.logviewer.backend;
import javax.management.Attribute;
import javax.management.AttributeList;

/**
 * LogRecordTemplate will be the first entry in the results that we return
 * back to the Admin Tool LogViewer Front end. It contains the metadata
 * describing the structure of the results.
 *
 * @AUTHOR: Hemanth Puttaswamy 
 *
 */
public class LogRecordTemplate {
    private static AttributeList template = 
        new AttributeList( );

    private static Attribute templateAttribute; 

    static {
        template.add( new Attribute( "FIELD0", "Record Number" ) ); 
        template.add( new Attribute( "FIELD1", "Logged DateTime" ) ); 
        template.add( new Attribute( "FIELD2", "Logged Level" ) ); 
        template.add( new Attribute( "FIELD3", "Product Name" ) ); 
        template.add( new Attribute( "FIELD4", "Logger Name" ) ); 
        template.add( new Attribute( "FIELD5", "Name Value Pairs" ) ); 
        template.add( new Attribute( "FIELD6", "Message Id" ) ); 
        template.add( new Attribute( "FIELD7", "Message" ) );

        templateAttribute = new Attribute( "Header", template );
    }

    static Attribute getHeader( ) {
        return templateAttribute;
    }
}
