/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server.ondemand;

import com.sun.enterprise.server.ondemand.entry.*;
import com.sun.enterprise.config.ConfigException;


/**
 * Main servicegroup implemmentation. This is a father
 * who does nothing. Its children are the actual servicegroups.
 * This class can be enhanced to contain all core services that
 * will always be started by appserver.
 *
 * @author Binod PG
 * @see ServiceGroup
 * @see ServiceGroupBuilder
 */
public class MainServiceGroup extends ServiceGroup {

    // Start all its children
    public void start(EntryContext context) 
    throws ServiceGroupException {
        super.startChildren(context);
    }

    // Stop all the children.
    public void stop(EntryContext context) 
    throws ServiceGroupException {
        super.stopChildren(context);
    }

    // Abort all children.
    public void abort(EntryContext context) {
        super.abortChildren(context);
    }

    // Always return true.
    public boolean analyseEntryContext(EntryContext context) {
        return true;
    }

}
