/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server.ondemand;

import java.util.Properties;
import com.sun.enterprise.server.pluggable.InternalServicesList;

/**
 * pluggable interface (this class will provide ApplicationServer
 * with the right lifecycles array)
 */
public class OnDemandServices implements InternalServicesList {

   public String[][] getServicesByName() {
        int sze = getEjbServiceGroupServices().length +
                  getWebServiceGroupServices().length +
                  getResourcesServiceGroupServices().length ;
        String[][] servicesByName = new String[sze][2];

        int idx = 0;
        for (String[] service : getEjbServiceGroupServices()) {
             servicesByName[idx][0] = service[0];
             servicesByName[idx][1] = service[1];
             idx++; 
        }

        for (String[] service : getWebServiceGroupServices()) {
             servicesByName[idx][0] = service[0];
             servicesByName[idx][1] = service[1];
             idx++; 
        }

        for (String[] service : getResourcesServiceGroupServices()) {
             servicesByName[idx][0] = service[0];
             servicesByName[idx][1] = service[1];
             idx++; 
        }

	return servicesByName;
   }


   // Return all services belongs to EJB servicegroup.
   public static String[][] getEjbServiceGroupServices() {
	String[][] servicesByName = {
	};
	return servicesByName;
   }

   // Return all services belongs to Web servicegroup.
   public static String[][] getWebServiceGroupServices () {
	String[][] servicesByName = {
                {"Servlet/JSP Service",
                "com.sun.enterprise.web.PEWebContainerLifecycle"},
	};
	return servicesByName;
   }

   // Return all services belongs to Resources servicegroup.
   public static String[][] getResourcesServiceGroupServices () {
	String[][] servicesByName = {
		{"JMSProvider", 
        	"com.sun.enterprise.jms.JmsProviderLifecycle"},
	};
	return servicesByName;
   }

}
