/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.server.ss.util;
                                                                                                                             
/**
 * When nio application uses Selector.selectedKeys(),
 * ASSelector will return a ASSet instance, where it will wrap 
 * those selection keys used for OP_ACCEPT.
 * Nio application might use Set.iterator() to remove the
 * processed SelectionKey from the selectedSet. We provide 
 * a wrapper Iterator so that even the actual selectedSet in
 * the Selector is modified.
 * 
 * @see ASSelector
 */
public class ASSet implements java.util.Set {

    private java.util.Set set = null;
    private ASWrapperCreator wCreator = null;

    public ASSet(java.util.Set set, ASWrapperCreator wCreator) {
        this.set = set;
        this.wCreator = wCreator;
    }

    public int size() {
        return set.size();
    }

    public boolean isEmpty() {
        return set.isEmpty();
    }

    public boolean contains(java.lang.Object obj) {
        return set.contains(obj);
    }

    public java.util.Iterator iterator() {
        return new ASIterator(this);
    }

    public Object[] toArray() {
        return set.toArray();
    }

    public Object[] toArray(java.lang.Object[] a) {
        return set.toArray(a);
    }

    public boolean add(java.lang.Object obj) {
        return set.add(obj);
    }

    public boolean remove(java.lang.Object obj) {
        return set.remove(obj);
    }

    public boolean containsAll(java.util.Collection c) {
        return set.containsAll(c);
    }

    public boolean addAll(java.util.Collection c) {
        return set.addAll(c);
    }

    public boolean retainAll(java.util.Collection c) { 
        return set.retainAll(c);
    }

    public boolean removeAll(java.util.Collection c) {
        return set.removeAll(c);
    }

    public void clear() {
        set.clear();
    }

    public boolean equals(java.lang.Object obj) {
        return set.equals(obj);
    }

    public int hashCode() {
        return set.hashCode();
    }

    java.util.Set actualSet() {
        return set;
    }

    Object wrapIfNecessary(Object next) {
        return wCreator.wrapIfNecessary(next);
    }
}
