/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;

/**
 * The Verifier Interface for use by the Appserver Deployment Backend
 */
public interface AppVerifyInterface {

   /**
    * Verify an Application Archive (.ear). 
    * @param application, the application descriptor
    * @param fileArchive, the Abstract archive representing the EAR 
    * @param outputDir, the directory to which the verifier output should be written
    *, this argument is optional and the user can choose to pass NULL. 
    * If this argument is NULL, the result would go to the verifier default 
    * output directory "/var/tmp/verifier-results".
    * @param cl, an initialized ClassLoader which verifier can use to load classes 
    * from the exploded Archive.
    * @return the ResultReport, the result
    **/

 public VerifierResults verifyEar(Application application,AbstractArchive fileArchive,
                                     String outputDir, ClassLoader cl);

   /**
    * Verify StandAlone Archive (.war/rar/jar).
    * @param application, the  descriptor
    * @param fileArchive, the Abstract archive representing the EAR 
    * @param outputDir, the directory to which the verifier output should be written
    *, this argument is optional and the user can choose to pass NULL. 
    * If this argument is NULL, the result would go to the verifier default 
    * output directory "/var/tmp/verifier-results".
    * @param cl, an initialized ClassLoader which verifier can use to load classes 
    * from the exploded Archive.
    * @return the ResultReport, the result
    **/
 public VerifierResults verifyStdAloneArchive(RootDeploymentDescriptor desc,
                                              AbstractArchive fileArchive, 
                                              String outputDir, ClassLoader cl);
}
