
/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.admin.event.*;
import com.sun.enterprise.admin.event.tx.JTSEvent;
import com.sun.enterprise.admin.event.tx.JTSEventListener;
import java.util.*;
import com.sun.enterprise.config.*;
import com.sun.enterprise.Switch;
//import com.sun.enterprise.config.serverbeans.*;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.jts.CosTransactions.Configuration;
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;

import com.sun.enterprise.util.i18n.StringManager;

/*
 * Listener for JTS dynamic configuration.
 */

public class JTSConfigChangeEventListener implements JTSEventListener
{
	// Sting Manager for Localization
	private static StringManager sm = StringManager.getManager(JTSConfigChangeEventListener.class);

 	// Logger to log transaction messages
 	static Logger _logger = LogDomains.getLogger(LogDomains.JTA_LOGGER);
    public String xPath = ServerXPathHelper.XPATH_TRANSACTION_SERVICE;

    private static ConfigChangeCategory category = new ConfigChangeCategory(
            "jts", ServerXPathHelper.REGEX_XPATH_CONFIG
                    + ServerXPathHelper.XPATH_SEPARATOR
                    + ServerXPathHelper.REGEX_ONE_PLUS 
                    + ServerTags.TRANSACTION_SERVICE + ".*"); 
	public static ConfigChangeCategory getCategory() { 
		return category; 
	}

    public void handleCreate(JTSEvent event) throws AdminEventListenerException {
        throw new AdminEventListenerException("handleCreate is not valid for JTSEvent");
    }

    public void handleDelete(JTSEvent event) throws AdminEventListenerException {
        throw new AdminEventListenerException("handleDelete is not valid for JTSEvent");
    }

    public void handleUpdate(JTSEvent event) throws AdminEventListenerException {
	    //Bug Id: 4666390 Handle no event in event list case
	    if(event==null){
			//do nothing
			return;
		}
        ArrayList configChangeList = event.getConfigChangeList();
	    if(configChangeList==null){
			//do nothing
			return;
		}
	    //Bug Id: 4666390 End

        ConfigUpdate configUpdate = null;
        boolean match = false;
        for (int i = 0; i < configChangeList.size(); i++) {
            configUpdate = (ConfigUpdate) configChangeList.get(i);
             if (configUpdate.getXPath() != null &&
                configUpdate.getXPath().endsWith(ServerTags.TRANSACTION_SERVICE)) {
                if (xPath.equals(configUpdate.getXPath())) {
                    match = true;
                    break;
                }
             }
        }
        if (match) { // TransactionService has been changed
            Set attributeSet = configUpdate.getAttributeSet();
            String next = null;
            for (Iterator iter = attributeSet.iterator(); iter.hasNext();) {
                next = (String) iter.next();
                if (next.equals(ServerTags.TIMEOUT_IN_SECONDS)) {
			        _logger.log(Level.FINE," Transaction Timeout interval event occurred");
                    String oldTimeout = configUpdate.getOldValue(ServerTags.TIMEOUT_IN_SECONDS);
                    String newTimeout = configUpdate.getNewValue(ServerTags.TIMEOUT_IN_SECONDS);
                    if (oldTimeout.equals(newTimeout)) {
                    }
                    else {
                        try {
                            Switch.getSwitch().getTransactionManager().setDefaultTransactionTimeout(
                                                                        Integer.parseInt(newTimeout,10));
                        } catch (Exception ex) {
							_logger.log(Level.WARNING,"transaction.reconfig_txn_timeout_failed",ex);
                        }
                    } // timeout-in-seconds
                }else if (next.equals(ServerTags.KEYPOINT_INTERVAL)) {
			        _logger.log(Level.FINE,"Keypoint interval event occurred");
                    String oldKeyPoint = configUpdate.getOldValue(ServerTags.KEYPOINT_INTERVAL);
                    String newKeyPoint = configUpdate.getNewValue(ServerTags.KEYPOINT_INTERVAL);
                    if (oldKeyPoint.equals(newKeyPoint)) {
                    }
                    else {
                        Configuration.setKeypointTrigger(Integer.parseInt(newKeyPoint,10));
                    }
                }else if (next.equals(ServerTags.RETRY_TIMEOUT_IN_SECONDS)) {
                    String oldRetryTiemout = configUpdate.getOldValue(ServerTags.RETRY_TIMEOUT_IN_SECONDS);
                    String newRetryTiemout = configUpdate.getNewValue(ServerTags.RETRY_TIMEOUT_IN_SECONDS);
			        _logger.log(Level.FINE,"retry_timeout_in_seconds reconfig event occurred " + newRetryTiemout);
                    if (oldRetryTiemout.equals(newRetryTiemout)) {
                    }
                    else {
                        Configuration.setCommitRetryVar(newRetryTiemout);
                    }
                }
				else {
            		// Not handled dynamically. Restart is required.
            		AdminEventMulticaster.notifyFailure(event, AdminEventResult.RESTART_NEEDED);
				}
				
                /*
		//This feature is currently dropped as it's not implemented totally
		else if (next.equals("commit-retries")) {
                    String oldCommitRetries = configUpdate.getOldValue("commit-retries");
                    String newCommitRetries = configUpdate.getNewValue("commit-retries");
                    if (oldCommitRetries.equals(newCommitRetries)) {
                    }
                    else {
                        Configuration.setCommitRetryVar(newCommitRetries);
                    }
                } // commit-retries
                */

            }
        }

    }
}
