/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.util;

import java.util.logging.*;
import com.sun.logging.*;


/**
 * Environment class that contains information about
 * from where this appserver instance is being invoked from 
 */
public class Environment {
    public static final int OPEN = 1;
    public static final int CLOSED = 0;

    private static String ENV_CLASS_NAME
         = "com.sun.enterprise.ee.util.OpenEnvironment";

    protected Environment() {
    }

    public int getEnvironmentStatus() {
         return Environment.CLOSED;
    }

    public static Environment obtain() {
        Environment e = new Environment();
        try {
            Object obj = java.security.AccessController.doPrivileged
                (new java.security.PrivilegedExceptionAction() {
                public java.lang.Object run() throws Exception {
                    return Class.forName(ENV_CLASS_NAME).newInstance();
                }
            });
            if (obj != null) {
                e = (Environment) obj;
            }
        } catch (Exception ex) {
        }
        return e;
    }

    public void unlock() {
        return;
    }
}
