/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.web.deploy;


import org.apache.catalina.deploy.ErrorPage;
import com.sun.enterprise.deployment.web.ErrorPageDescriptor;


import org.apache.catalina.util.RequestUtil;
import java.io.Serializable;


/**
 * Decorator of class <code>org.apache.catalina.deploy.ErrorPage</code>
 *
 * @author Jean-Francois Arcand
 */

public class ErrorPageDecorator extends ErrorPage {

    private ErrorPageDescriptor decoree;
    
    private String location;
    
    public ErrorPageDecorator(ErrorPageDescriptor decoree){
        this.decoree = decoree;
        setErrorCode(decoree.getErrorCode());
         String  exceptionType = decoree.getExceptionType();
        if (exceptionType.equals("")){
            setExceptionType(null);
        } else {
            setExceptionType(exceptionType);
        }
        
        setLocation(RequestUtil.URLDecode(decoree.getLocation()));
    }
}
