/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.webservice;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
/**
 * Utility used by JBI's ServiceEngine to help ServiceEngineWSDelegate retrieve
 * corresponding ServiceReferenceDescriptor object
 * @author Manisha Umbarje 
 */
public class ServiceRefDescUtil {

    private static ThreadLocal localDesc = new ThreadLocal(); 
    public ServiceRefDescUtil() {
    }
 
    /**
     * ServiceEngineWSDelegate retrieves the copy of ServiceReferenceDescriptor
     * in its constructor
     */ 
    public static ServiceReferenceDescriptor getReference() {
       //It's assumed that Service is JBI Enabled and thread local is set
       // if this method is invoked
       return (ServiceReferenceDescriptor) localDesc.get(); 
    } 
    
    /**
     * Just before creating the Service Object, it's ServiceReferenceDescriptor
     * object is stored in the thread local 
     */ 
    public void preServiceCreate(ServiceReferenceDescriptor descObj) {
       localDesc.set(descObj);
    }

    /**
     * After service creation the threadlocal object is destroyed
     */
    public void postServiceCreate() {
        localDesc.set(null);
    }
}
