/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * JAXRPCEndpointImpl.java
 */

package com.sun.enterprise.webservice.monitoring;

import com.sun.xml.rpc.spi.runtime.SOAPMessageContext;
import com.sun.xml.rpc.spi.runtime.SystemHandlerDelegate;

/**
 * Implementation of the JAXRPC endpoint interface and JAXRPC System Handler Delegate
 *
 * @author Jerome Dochez
 */
public class JAXRPCEndpointImpl extends EndpointImpl implements SystemHandlerDelegate {
    
    SystemHandlerDelegate parent = null;
    
    /** Creates a new instance of EndpointImpl */
    JAXRPCEndpointImpl(String endpointSelector, EndpointType type) {
        super(endpointSelector, type);
    }
    
    public boolean processRequest(SOAPMessageContext messageContext) {

	boolean status = true;

        if (parent!=null) {
            status = parent.processRequest(messageContext);
        }

        // let's get our thread local context
        WebServiceEngineImpl wsEngine = WebServiceEngineImpl.getInstance();
        try {
            if (!listeners.isEmpty() || wsEngine.hasGlobalMessageListener()) {
                
                // someone is listening
                ThreadLocalInfo config = 
                        (ThreadLocalInfo) wsEngine.getThreadLocal().get();

                // do we have a global listener ?
                if (config!=null && config.getMessageId()!=null) {
                    HttpRequestInfoImpl info = new HttpRequestInfoImpl(config.getRequest());
                    wsEngine.processRequest(config.getMessageId(), messageContext, info);
                } 
                
                // any local listeners ?
                if (!listeners.isEmpty()) {
                    if (config==null) {
                        config = new ThreadLocalInfo(null, null);
                    }
                    // create the message trace and save it to our thread local
                    MessageTraceImpl request = new MessageTraceImpl();
                    request.setEndpoint(this);
                    request.setMessageContext(messageContext);
                    if (config.getRequest()!=null) {
                        request.setTransportInfo(new HttpRequestInfoImpl(config.getRequest()));
                    }
                    
                    config.setRequestMessageTrace(request);
                }
                
            }
	} catch(Throwable t) {
            wsEngine.sLogger.warning("Exception while tracing request : " + t.getMessage());
	    RuntimeException re;
	    if (t instanceof RuntimeException) {
		re = (RuntimeException) t;
	    } else {
		re = new RuntimeException(t);
	    }
	    throw re;
        }
        
        return status;
    }

    public void processResponse(SOAPMessageContext messageContext) {   

        // let's get our thread local context
        WebServiceEngineImpl wsEngine = WebServiceEngineImpl.getInstance();
        try {
            
            if (wsEngine.hasGlobalMessageListener() || !listeners.isEmpty()) {
                
                // someone is listening
                ThreadLocalInfo config = 
                        (ThreadLocalInfo) wsEngine.getThreadLocal().get();

                if (config!=null) {                    
                    // do we have a global listener ?
                    if (config.getMessageId()!=null) {
                        wsEngine.processResponse(config.getMessageId(),  messageContext);
                    }

                    // local listeners
                    if (!listeners.isEmpty()) {
                        MessageTraceImpl response = new MessageTraceImpl();
                        response.setEndpoint(this);
                        response.setMessageContext(messageContext);
                        for (MessageListener listener : listeners) {                    
                            listener.invocationProcessed(config.getRequestMessageTrace(), response);
                        }   
                    }
                }
            }
            // cleanup
            wsEngine.getThreadLocal().remove();
            
	    // do security after tracing
	    if (parent!=null) {
		parent.processResponse(messageContext);
	    }
        
        } catch(Throwable t) {
            wsEngine.sLogger.warning("Exception while tracing response : " + t.getMessage());
	    RuntimeException re;
	    if (t instanceof RuntimeException) {
		re = (RuntimeException) t;
	    } else {
		re = new RuntimeException(t);
	    }
	    throw re;
        }                 

    }
    
    public void setParent(SystemHandlerDelegate parent) {
        this.parent = parent;
    }        
}
