/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.webservice.monitoring;

import java.security.Principal;
import java.util.logging.Logger;
import java.util.logging.Level;
import javax.enterprise.deploy.shared.ModuleType;

import com.sun.logging.LogDomains;
import com.sun.enterprise.deployment.BundleDescriptor;

/**
 * Log all authentication successes and failures.
 *
 * @author Jerome Dochez
 */
public class LogAuthenticationListener implements AuthenticationListener {
    
    private static Logger ejbLogger
        = LogDomains.getLogger(LogDomains.EJB_LOGGER);
    private static Logger webLogger
        = LogDomains.getLogger(LogDomains.WEB_LOGGER);
    
    
    /** Creates a new instance of LogAuthenticationListener */
    public LogAuthenticationListener() {
    }
    
    /**
     * notification that a user properly authenticated while making 
     * a web service invocation.
     */
    public void authSucess(BundleDescriptor bundleDesc, Endpoint endpoint, Principal principal) {
        if (ModuleType.EJB.equals(bundleDesc.getModuleType())) {
            if (ejbLogger.isLoggable(Level.FINER)) {
                ejbLogger.finer("LOG LISTENER : authentication succeeded for " 
                        +  endpoint.getEndpointSelector());                
            }
        } else {
            if (webLogger.isLoggable(Level.FINER)) {
                webLogger.finer("authentication succeeded for endpoint in " +
                        bundleDesc.getModuleID() + " web app");
            }
        }
    }
    
    /**
     * notification that a user authentication attempt has failed.
     * @param endpointSelector the endpoint selector 
     * @param principal Optional principal that failed
     */
    public void authFailure(BundleDescriptor bundleDesc, Endpoint endpoint, Principal principal) {
        if (ModuleType.EJB.equals(bundleDesc.getModuleType())) {
            if (ejbLogger.isLoggable(Level.FINE)) {
                ejbLogger.fine("authentication failure for " 
                        +  endpoint.getEndpointSelector());                
            }
        } else {
            if (webLogger.isLoggable(Level.FINE)) {
                webLogger.fine("authentication failure for endpoint in " +
                        bundleDesc.getModuleID() + " web app");
            }
        }
    }
}
