/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.webservice.monitoring;

import javax.servlet.http.HttpServletRequest;

/**
 * This class encapsulates all information contained in the thread local
 * for servlet invocations to trace the messages.
 *
 * @author Jerome Dochez
 */
public class ThreadLocalInfo {
    
    final private String messageId;
    final private HttpServletRequest request;
    private MessageTraceImpl requestMessageTrace;
    
    /** Creates a new instance of ServletThreadLocalConfiguration */
    public ThreadLocalInfo(String messageId, HttpServletRequest request) {
        this.messageId = messageId;
        this.request = request;
    }
    
    public String getMessageId() {
        return messageId;
    }
    
    public HttpServletRequest getRequest() {
        return request;
    }
    
    public void setRequestMessageTrace(MessageTraceImpl trace) {
        requestMessageTrace = trace;
    }
    
    public MessageTraceImpl getRequestMessageTrace() {
        return requestMessageTrace;
    }
    
    
}
