/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.webservice.spi;

import javax.xml.ws.Dispatch;

/**
 * Interface to listen to port or Dispatch instance creation
 *
 * @author Jerome Dochez
 */
public interface InvInterfaceCreationListener {
   
    /**
     * Notification of a port creation. The port creation is actually blocked
     * until this method returns so lenghly process should be done 
     * asynchronously.
     * @param port instance
     * @param service endpoint interface type
     */
    public <T> void portCreated(T port, Class<T> serviceEndpointInterface);
       
    /**
     * Notification of a dispatch instance creation. The dispatch creation is 
     * blocked until the method returns so lengthly process should be done
     * asynchronously
     * @param dispatch instance
     * @param service endpoint interface type
     */
    public <T> void dispatchCreated(Dispatch<T> dispatch, Class<T> serviceEndpointInterface);    
}
        