/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.jndi.url.corbaname;

import javax.naming.Context;
import javax.naming.NamingException;
import org.omg.CORBA.ORB;
import org.omg.CosNaming.NamingContext;
import java.util.Hashtable;

import com.sun.jndi.cosnaming.CNCtxFactory;

/**
 * A utility class for calling the package private CNCtx constructor.
 * @author Rosanna Lee
 */

final public class CNCtxHelper {
    public static final Context getInstance(ORB orb, org.omg.CORBA.Object ncref, 
	Hashtable env) throws NamingException {
	if (env != null) {
	    env = (Hashtable) env.clone();
	}

	// Get stringify IOR and put into environment
	String ncrefStr = orb.object_to_string(ncref);

	env.put(Context.PROVIDER_URL, ncrefStr);

	return new CNCtxFactory().getInitialContext(env);
    }
}
