/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */ 

package org.apache.taglibs.standard.examples.taglib;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;

import org.apache.taglibs.standard.examples.util.Util;

/**
 * <p>Tag handler for &lt;escapeHtml&gt;
 *
 * @author Pierre Delisle
 * @version $Revision: 1.2 $ $Date: 2005/12/08 01:20:40 $
 */
public class EscapeHtmlTag extends BodyTagSupport {
    
    //*********************************************************************
    // Instance variables
    
    private Object reader;
    private Object writer;
    
    //*********************************************************************
    // Constructors
    
    public EscapeHtmlTag() {
        super();
        init();
    }
    
    private void init() {
        reader = null;
        writer = null;
    }
    
    
    //*********************************************************************
    // Tag's properties
    
    /**
     * Tag's 'reader' attribute
     */
    public void setReader(Object reader) {
        this.reader = reader;
    }
    
    /**
     * Tag's 'writer' attribute
     */
    public void setWriter(Object writer) {
        this.writer = writer;
    }
    
    //*********************************************************************
    // TagSupport methods
    
    public int doEndTag() throws JspException {
        Reader in;
        Writer out;
        
        if (reader == null) {
            String bcs = getBodyContent().getString().trim();
            if (bcs == null || bcs.equals("")) {
                throw new JspTagException("In &lt;escapeHtml&gt;, 'reader' " +
                "not specified and no non-whitespace content inside the tag.");
            }
            in = Util.castToReader(bcs);
        } else {
            in = Util.castToReader(reader);
        }
        
        if (writer == null) {
            out = pageContext.getOut();
        } else {
            out = Util.castToWriter(writer);
        }
        
        transform(in, out);
        return EVAL_PAGE;
    }
    
    /**
     * Releases any resources we may have (or inherit)
     */
    public void release() {
        super.release();
        init();
    }
    
    //*********************************************************************
    // Tag's scific behavior methods
    
    /**
     * Transform
     */
    public void transform(Reader reader, Writer writer)
    throws JspException {
        int c;
        try {
            writer.write("<pre>");
            while ((c = reader.read()) != -1) {
                if (c == '<') {
                    writer.write("&lt;");
                } else if (c == '>') {
                    writer.write("&gt;");
                } else {
                    writer.write(c);
                }
            }
            writer.write("</pre>");
        } catch (IOException ex) {
            throw new JspException("EscapeHtml: " +
            "error copying chars", ex);
        }
    }
}
