/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

#include <pwd.h>

#ifdef STANDALONE
#include <stdio.h>
#else
#include <jni.h>;
#include "com_sun_enterprise_security_audit_bsm_BSMAuditManager.h";
#endif

int*
nativeGetUidGid(char* user)
{
    struct passwd *pw;
    int ids[2] = { -1, -1};
    if (user != NULL && strlen(user)) {
       pw = getpwnam(user);
       if (pw != NULL) {
          ids[0] = pw->pw_uid;
          ids[1] = pw->pw_gid;
       }
    }
    return ids;
}

#ifndef STANDALONE
JNIEXPORT jintArray JNICALL
Java_com_sun_enterprise_security_audit_bsm_BSMAuditManager_nativeGetUidGid
(JNIEnv *env, jclass class, jstring juser)
{
    int* ids; 
    int* temp; 
    jint* jids;
    jintArray idArray;
    const char *user;
    user = (*env)->GetStringUTFChars(env, juser, NULL);
    ids = nativeGetUidGid(user);

    jids = (jint*)malloc(2 *sizeof(jint));
    temp = ids;
    if (temp != NULL && temp++ != NULL) {
        jids[0] = ids[0];
        jids[1] = ids[1];
    } else {
        // should never be here
        jids[0] = -1;
        jids[1] = -1;
    }
    idArray = (*env)->NewIntArray(env, 2);
    (*env)->SetIntArrayRegion(env, idArray, 0, 2, jids);

    (*env)->ReleaseStringUTFChars(env, juser, user);
    free(jids);
    ids = NULL;
    temp = NULL;

    return idArray;
}
#endif

#ifdef STANDALONE
int
main(int argc, char *argv[])
{
    char *user;
    int* ids;
    int* temp;
    if (argc != 2) {
        printf("Please input a username as argument.\n");
        exit(2);
    }
    user = argv[1];
    printf("user = %s\n", user);
    ids = nativeGetUidGid(user);
    temp = ids;
    if (temp != NULL && temp++ != NULL) {
        printf("uid = %d, gid = %d\n", ids[0], ids[1]);
    } else {
        printf("uid, gid is NULL\n");
    }
}
#endif
