/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.logging;

import java.util.Hashtable;
import java.util.logging.Logger;

/**
 * Class LogDomains
 */
public class LogDomains {

    
    private static final String DOMAIN_ROOT = "javax.enterprise.";

    public static final String AVK_VERIFIER_LOGGER =
        DOMAIN_ROOT + "system.tools.avk.tools.verifier";

    public static final String AVK_APPVERIFICATION_LOGGER =
        DOMAIN_ROOT + "system.tools.avk.appverification";

    public static final String AVK_APPVERIFICATION_TOOLS_LOGGER =
        DOMAIN_ROOT + "system.tools.avk.appverification.tools";

    public static final String AVK_APPVERIFICATION_XML_LOGGER =
        DOMAIN_ROOT + "system.tools.avk.appverification.xml";

    // RESOURCE_BUNDLES the name of the logging resource bundles.

    private static final String PACKAGE_ROOT = "com.sun.enterprise.";

    private static final String AVK_VERIFIER_BUNDLE =
        PACKAGE_ROOT + "tools.verifier.LocalStrings";

    // Note that these 3 bundles are packaged only in javke.jar and
    // they are not present in appserv-rt.jar
    private static final String AVK_APPVERIFICATION_BUNDLE =
        PACKAGE_ROOT + "appverification.LocalStrings";

    private static final String AVK_APPVERIFICATION_TOOLS_BUNDLE =
        PACKAGE_ROOT + "appverification.tools.LocalStrings";

    private static final String AVK_APPVERIFICATION_XML_BUNDLE =
        PACKAGE_ROOT + "appverification.xml.LocalStrings";

    // static field
    private static Hashtable<String, Logger> loggers = null;

    // static initializer
    static {
      loggers = new Hashtable<String, Logger>();
      loggers.put(AVK_VERIFIER_LOGGER,
                  Logger.getLogger(AVK_VERIFIER_LOGGER,
                                   AVK_VERIFIER_BUNDLE));
      // When run in instrumentation mode, with javke.jar in classpath
      // the calls below will succeed
      try {
      loggers.put(AVK_APPVERIFICATION_LOGGER,
                  Logger.getLogger(AVK_APPVERIFICATION_LOGGER,
                                   AVK_APPVERIFICATION_BUNDLE));
      loggers.put(AVK_APPVERIFICATION_TOOLS_LOGGER,
                  Logger.getLogger(AVK_APPVERIFICATION_TOOLS_LOGGER,
                                   AVK_APPVERIFICATION_TOOLS_BUNDLE));
      loggers.put(AVK_APPVERIFICATION_XML_LOGGER,
                  Logger.getLogger(AVK_APPVERIFICATION_XML_LOGGER,
                                   AVK_APPVERIFICATION_XML_BUNDLE));
      }catch(Exception e) {
         // during normal appserver-run, these 3 initializations will fail
      }
    }

    private LogDomains() {} // prevent instance creation

    public static Logger getLogger(String name) {
        return (Logger) loggers.get(name);
    }

}
