/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
/*
 * TestInformation.java
 *
 * Created on December 4, 2000, 4:29 PM
 */

package com.sun.enterprise.tools.verifier;

/**
 * Holds information about a particular test like the name of the class
 * implementing the test or the version of the spec it applies to
 *
 * @author Jerom Dochez
 */
public class TestInformation extends Object {

    private String className = null;
    private String minimumVersion = null;
    private String maximumVersion = null;

    /**
     * @return the className implementing the test
     */
    public String getClassName() {
        return className;
    }

    /*
     * set the class name implementing the test
     * 
     * @param className is the class name
     */
    public void setClassName(String className) {
        this.className = className;
    }

    /**
     * @return the minimum version of the spec this test applies to
     */
    public String getMinimumVersion() {
        return minimumVersion;
    }

    /**
     * set the minimum version of the spec this test applies to
     *
     * @param minimumVersion is the version
     */
    public void setMinimumVersion(String minimumVersion) {
        this.minimumVersion = minimumVersion;
    }

    /**
     * @return maximumVersion the maximum version of the spec this test applies to
     */
    public String getMaximumVersion() {
        return maximumVersion;
    }

    /**
     * set the minimum version of the spec this test applies to
     *
     * @param maximumVersion is the version
     */
    public void setMaximumVersion(String maximumVersion) {
        this.maximumVersion = maximumVersion;
    }
}