/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

/**
 * Reads the list of file names from the file cleandirs.txt and
 * calls deleteFile to recursively delete the directories.
 * NOTE : This independent class gets called only on W2K, where the
 * Normal cleanAll() call from doit() in verifier fails.
 */
public class TmpCleaner {

    private final static String TMPDIR = System.getProperty("java.io.tmpdir");

    public void run() {

        // read the file
        try {
            String cleandirs = TMPDIR + File.separator + "cleandirs.txt"; // NOI18N
            File tmpfile = new File(cleandirs);
            if (!tmpfile.exists())
                return;
            BufferedReader br = new BufferedReader(new FileReader(cleandirs));

            try {
                do {
                    String str = br.readLine();
                    String file = TMPDIR + File.separator + str;
                    File toDelete = new File(file);
                    deleteFile(toDelete);
                    toDelete.deleteOnExit();
                } while (br.ready());
            } catch (Exception e) {
            }


            br.close();
            File f = new File(cleandirs);
            f.delete();
        } catch (Exception e) {
        }
    }

    private void deleteFile(File p_file) {
        String FILE_SEPARATOR = System.getProperty("file.separator");
        // If it is a directory, empty it first
        if (p_file.isDirectory()) {
            String[] dirList = p_file.list();
            for (int i = 0; i < dirList.length; i++) {

                File aFile = new File(
                        p_file.getPath() + FILE_SEPARATOR + dirList[i]);
                if (aFile.isDirectory()) {
                    deleteFile(aFile);
                }
                aFile.delete();
            }
        }
        p_file.delete();
    }


    public static void main(String[] args) {
        try {
            TmpCleaner t = new TmpCleaner();
            System.gc();
            t.run();
        } catch (Exception e) {
        }
        System.exit(0);
    }

}
