/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier;

import java.util.EventObject;

/**
 * <p/>
 * This listener interface is used for tests that need to be notified of the
 * verifier execution life cycle
 * </p>
 *
 * @author Jerome Dochez
 */
public interface VerifierEventsListener {

    /**
     * <p/>
     * Individual test completion notification event
     * </p>
     *
     * @param e event object which source is the result of the individual test
     */
    void testFinished(EventObject e);

    /**
     * <p/>
     * Notification that all tests pertinent to a verifier check manager have
     * been completed
     * </p>
     *
     * @param e event object which source is the check manager for the
     * completed tests
     */
    void allTestsFinished(EventObject e);
}