/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.apiscan.classfile;

import java.util.logging.Logger;

/**
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class Util {

    private static Logger logger = Logger.getLogger("apiscan.classfile"); // NOI18N

    private static final String myClassName = "Util"; // NOI18N

    /**
     * @param internalClsName is the name in internal format
     * @return the class name in external format, i,e. format used in reflection
     *         API (e.g. Class.forName())
     */
    public static String convertToExternalClassName(String internalClsName) {
        return internalClsName.replace('/', '.');
    }

    /**
     * @param externalClsName is the name in internal format
     * @return the class name in internal format, i,e. format used in byte code
     */
    public static String convertToInternalClassName(String externalClsName) {
        return externalClsName.replace('.', '/');
    }

    public static boolean isPrimitive(String className) {
        logger.entering(myClassName, "isPrimitive", new Object[]{className}); // NOI18N
        boolean result = ("B".equals(className) || // NOI18N
                "C".equals(className) || // NOI18N
                "D".equals(className) || // NOI18N
                "F".equals(className) || // NOI18N
                "I".equals(className) || // NOI18N
                "J".equals(className) || // NOI18N
                "S".equals(className) || // NOI18N
                "Z".equals(className)); // NOI18N
        logger.exiting(myClassName, "isPrimitive", result); // NOI18N
        return result;
    }
}
