/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;


/** 
 * Application's name test.
 * The Application provider must assign a display name to each Application
 */
public class AppName extends ApplicationTest implements AppCheck { 


    /** 
     * Application's name test.
     * The Application provider must assign a display name to each Application
     *
     * @param descriptor the Application deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(Application descriptor) {

	Result result = getInitializedResult();

    
	String appName = descriptor.getName();

	if (appName != null && appName.length() > 0 ) {
	    // as long as it's not blank, test should pass
	    result.passed
		(smh.getLocalString
		 (getClass().getName() + ".passed", 
		  "Application display name is : [ {0} ]", 
		  new Object [] {appName}));
	} else {
	    // it's blank, test should not pass
	    
		result.failed
		(smh.getLocalString
		 (getClass().getName() + ".failed", 
		  "Error: Application display name cannot be blank."));
	} 
	return result;
    }
}
