/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import java.util.*;
import java.io.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.security.acl.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.util.FileClassLoader;


/** 
 * The Application role-name element contains the name of a security role.
 */
public class AppSecurityRole extends ApplicationTest implements AppCheck { 

    

    /** 
     * The Application role-name element contains the name of a security role.
     *
     * @param descriptor the Application deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(Application descriptor) {

	Result result = getInitializedResult();


	if (!descriptor.getRoles().isEmpty()) {
	    boolean oneFailed = false;
	    boolean foundIt = false;
	    // get the security role name's in this app
	    Set sc = descriptor.getRoles();
	    Iterator itr = sc.iterator();
	    while (itr.hasNext()) {
		foundIt = false;
		Role role = (Role) itr.next();
		String roleName = role.getName(); 
		if (roleName.length() > 0) {
		    foundIt = true;
		} else {
		    foundIt = false;
		}

      
		if (foundIt) {
		    result.addGoodDetails(smh.getLocalString
					  (getClass().getName() + ".passed",
					   "The security role name [ {0} ] found within application [ {1} ]",
					   new Object[] {roleName, descriptor.getName()}));
		} else {
		    if (!oneFailed) {
			oneFailed = true;
		    }
		    result.addErrorDetails(smh.getLocalString
					   (getClass().getName() + ".failed",
					    "Error: The security role name [ {0} ] not found within application [ {1} ]",
					    new Object[] {roleName, descriptor.getName()}));
		}
	    }
	    if (oneFailed) {
		result.setStatus(Result.FAILED);
	    } else {
		result.setStatus(Result.PASSED);
	    }
	} else {
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "There are no role-name elements within the application [ {0} ]",
				  new Object[] {descriptor.getName()}));
	}

	return result;
    }
}
