/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.appclient;

import java.lang.reflect.Modifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;

/**
 * Application clients start execution at the main method of the class specified
 * in the Main-Class attribute in the manifest file of the application client’s
 * JAR file. It must be specified in the MANIFEST file.
 * @author Sudipto Ghosh
 */
public class AppClientMainClass extends AppClientTest implements AppClientCheck  {

    public Result check(ApplicationClientDescriptor descriptor) {
        Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

        String mainClass = descriptor.getMainClassName();
        if (mainClass != null && mainClass.length() > 0) {
            try { 
                Class c = Class.forName(mainClass, false, getVerifierContext().getClassLoader());
                if(!Modifier.isPublic(c.getModifiers())) {
                    addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(getClass().getName() + ".failed2",
                            "ERROR: Appclient main-class [ {0} ] as specified in the Manifest file is not public.",
                            new Object[] {mainClass}));
                }
            } catch (ClassNotFoundException cnfe) {
                if(debug)
                    cnfe.printStackTrace();
                addErrorDetails(result, compName);
                result.failed(smh.getLocalString(getClass().getName() + ".failed1",
                        "ERROR: Appclient main-class [ {0} ] as specified in the" +
                        " Manifest file is not loadable.",
                        new Object[] {mainClass}));
            }
        } else {
            addErrorDetails(result, compName);
            result.failed(smh.getLocalString
                    (getClass().getName() + ".failed",
                            "Appclient main-class is not found. Please check the " +
                    "main-class entry of your appclient manifest file."));
        }
        if(result.getStatus() != Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString(getClass().getName() + ".passed",
                    "main-class entry is defined properly."));
        }
        return result;
    }
}
