/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
/*
 * ManagedConnectionGetMetaData.java
 *
 * Created on August 26, 2002
 */

package com.sun.enterprise.tools.verifier.tests.connector.managed;

import java.io.File;
import java.lang.reflect.Method;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.tests.*;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;

/**
 * Test that the return type of
 * javax.resource.spi.ManagedConnection.getMetaData() implements 
 * the ManagedConnectionMetaData interface.
 *
 * @author Anisha Malhotra 
 * @version 
 */
public class ManagedConnectionGetMetaData
    extends ConnectorTest 
    implements ConnectorCheck 
{
  /** <p>
   * Test that the return type of
   * javax.resource.spi.ManagedConnection.getMetaData() implements 
   * the ManagedConnectionMetaData interface.
   * </p>
   *
   * @param descriptor deployment descriptor for the rar file
   * @return result object containing the result of the individual test
   * performed
   */
  public Result check(ConnectorDescriptor descriptor) {

    Result result = getInitializedResult();
    ComponentNameConstructor compName = 
      getVerifierContext().getComponentNameConstructor();
    // test NA for inboundRA
    if(!descriptor.getOutBoundDefined())
    {
      result.addNaDetails(smh.getLocalString
          ("tests.componentNameConstructor",
           "For [ {0} ]",
           new Object[] {compName.toString()}));
      result.notApplicable(smh.getLocalString
          ("com.sun.enterprise.tools.verifier.tests.connector.managed.notApplicableForInboundRA",
           "Resource Adapter does not provide outbound communication"));
      return result;
    }
	//File jarFile = Verifier.getJarFile(descriptor.getModuleDescriptor().getArchiveUri());
//        File f=Verifier.getArchiveFile(descriptor.getModuleDescriptor().getArchiveUri());
        Class c = findImplementorOf(descriptor, "javax.resource.spi.ManagedConnection");
    if(c == null)
    {
      result.addErrorDetails(smh.getLocalString
          ("tests.componentNameConstructor",
           "For [ {0} ]",
           new Object[] {compName.toString()}));
      result.failed(smh.getLocalString
          ("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.findImplementor.failed", 
           "Error: There is no implementation of the [ {0} ] provided",
           new Object[] {"javax.resource.spi.ManagedConnection"}));        
      return result;
    }
    // get return type of getMetaData()
    Method m = null;
    do {
      try {
        m = c.getMethod("getMetaData", (Class[])null);
      } catch(NoSuchMethodException nsme) {
      } catch(SecurityException se) {
      }
      c = c.getSuperclass();
    } while (m != null && c != Object.class);            
    if(m == null)
    {
      result.addErrorDetails(smh.getLocalString
          ("tests.componentNameConstructor",
           "For [ {0} ]",
           new Object[] {compName.toString()}));
      result.failed(smh.getLocalString
          ("com.sun.enterprise.tools.verifier.tests.connector.managed.ManagedConnectionGetMetaData.failed", 
           "Error: There is no implementation of getMetaData() provided"));
      return result;
    }
    Class returnType = m.getReturnType();
    if(VerifierTest.isImplementorOf(returnType, 
          "javax.resource.spi.ManagedConnectionMetaData"))
    {
      result.addGoodDetails(smh.getLocalString
          ("tests.componentNameConstructor",
           "For [ {0} ]",
           new Object[] {compName.toString()}));
      result.passed(smh.getLocalString
          ("com.sun.enterprise.tools.verifier.tests.connector.managed.ManagedConnectionGetMetaData.passed", 
           "ManagedConnection.getMetaData() returns an instance of the" + 
           "javax.resource.spi.ManagedConnectionMetaData interface"));
    }
    else
    {
      result.addErrorDetails(smh.getLocalString
          ("tests.componentNameConstructor",
           "For [ {0} ]",
           new Object[] {compName.toString()}));
      result.failed(smh.getLocalString
          ("com.sun.enterprise.tools.verifier.tests.connector.managed.ManagedConnectionGetMetaData.failed1", 
           "Error: getMetaData() does not return an instance of the" + 
           "javax.resource.spi.ManagedConnectionMetaData interface"));
    }
    return result;
  }
}
