/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;


/**
 * Bean interface type test.  
 * The bean provider must provide either Local or Remote or Both interfaces
 *
 * @author Sheetal Vartak
 */
public class EjbHasLocalorRemoteorBothInterfaces extends EjbTest implements EjbCheck {

    /**
     * Bean interface type test.  
     * The bean provider must provide either Local or Remote or Both interfaces
     *   
     * @param descriptor the Enterprise Java Bean deployment descriptor   
     *
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

        Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

        if (!(descriptor instanceof EjbSessionDescriptor) &&
                !(descriptor instanceof EjbEntityDescriptor)) {
            addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString
                    ("com.sun.enterprise.tools.verifier.tests.ejb.intf.InterfaceClassExist.notApplicable1",
                            "Test apply only to session or entity beans."));
            return result;
        }
        if ((descriptor.getRemoteClassName() == null || "".equals(descriptor.getRemoteClassName()))&&
                (descriptor.getLocalClassName() == null || "".equals(descriptor.getLocalClassName()))) {

            if (implementsEndpoints(descriptor)) {
                addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString
                        ("com.sun.enterprise.tools.verifier.tests.ejb.webservice.notapp",
                                "Not Applicable because, EJB [ {0} ] implements a Service Endpoint Interface.",
                                new Object[] {compName.toString()}));
                return result;
            }
            else {
                addErrorDetails(result, compName);
                result.failed(smh.getLocalString
                        (getClass().getName() + ".failed",
                                "Ejb [ {0} ] does not have local or remote interfaces",
                                new Object[] {descriptor.getEjbClassName()}));
                return result;
            }
        }
        else {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                    (getClass().getName() + ".passed",
                            "Ejb [ {0} ] does have valid local and/or remote interfaces",
                            new Object[] {descriptor.getEjbClassName()}));
            return result;
        }
    }
}

