/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

/**
 * Enterprise bean's name test.
 * The Bean provider must assign a logical name to each enterprise bean in 
 * the ejb-jar file.
 */
public class EjbLogicalName extends EjbTest implements EjbCheck {

    /**
     * Enterprise bean's name test.
     * The Bean provider must assign a logical name to each enterprise bean in 
     * the ejb-jar file.
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor 
     *
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

        Result result = getInitializedResult();
        String ejbName = descriptor.getName();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        if (!ejbName.equals("")) {
            // as long as it's not blank, test should pass
            //result.passed("EJB logical name is : "+ejbName);
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                    (getClass().getName() + ".passed",
                            "EJB logical name is: [ {0} ]",
                            new Object[] {ejbName}));
        } else {
            addErrorDetails(result, compName);
            // it's blank, test should not pass
            result.failed(smh.getLocalString
                    (getClass().getName() + ".failed",
                            "Error: EJB logical name cannot be blank."));
        }
        return result;
    }
}

