/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.NameToken;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;

/**
 * The ejb-name must conform to the lexical rules for an NMTOKEN
 */
public class EjbNameNMTOKEN extends EjbTest implements EjbCheck {



    /**
     * The ejb-name must conform to the lexical rules for an NMTOKEN
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

        Result result = getInitializedResult();
        String ejbName = descriptor.getName();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

        // The ejb-name must conform to the lexical rules for an NMTOKEN
        if (!(NameToken.isNMTOKEN(ejbName))) {
            // it's bad, test should not pass
            addErrorDetails(result, compName);
            result.failed
                    (smh.getLocalString
                    (getClass().getName() + ".failed",
                            "Error: [ {0} ] does not conform to the lexical rules of NMTOKEN within bean [ {1} ]",
                            new Object[] {ejbName, descriptor.getName()}));
        } else {
            addGoodDetails(result, compName);
            result.passed
                    (smh.getLocalString
                    (getClass().getName() + ".passed",
                            "[ {0} ] conforms to the lexical rules of NMTOKEN within bean [ {1} ]",
                            new Object[] {ejbName, descriptor.getName()}));
        }
        return result;
    }

}
