/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import java.util.Iterator;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;

/**
 * The ejb-ref-name element contains the name of an EJB reference. The EJB 
 * reference is an entry in the enterprise bean's environment. It is 
 * recommended that name is prefixed with "ejb/".
 */
public class EjbRefNamePrefixed extends EjbTest implements EjbCheck {

    /**
     * The ejb-ref-name element contains the name of an EJB reference. The EJB 
     * reference is an entry in the enterprise bean's environment. It is 
     * recommended that name is prefixed with "ejb/".
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

        Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

        if (!descriptor.getEjbReferenceDescriptors().isEmpty()) {
            for (Iterator itr = descriptor.getEjbReferenceDescriptors().iterator();
                 itr.hasNext();) {
                EjbReferenceDescriptor nextEjbReference = (EjbReferenceDescriptor) itr.next();
                String ejbRefName = nextEjbReference.getName();
                if (!ejbRefName.startsWith("ejb/")) {
                    addWarningDetails(result, compName);
                    result.addWarningDetails(smh.getLocalString
                            (getClass().getName() + ".warning",
                            "Warning: [ {0} ] is not prefixed with recommended string " +
                            "ejb/ within bean [ {1} ]",
                            new Object[] {ejbRefName,descriptor.getName()}));
                }
            }
        }
        if (result.getStatus() != Result.WARNING) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                    (getClass().getName() + ".passed",
                    "ejb-ref-name is properly defined within bean [ {0} ]",
                    new Object[] {descriptor.getName()}));
        }
        return result;
    }
}
