/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import java.lang.ClassLoader;
import com.sun.enterprise.tools.verifier.tests.*;

/** 
 * ejb-jar file must contain the java class file of the enterprise bean 
 * implementation class, and any of the classes that it depends on.
 */
public class JarFileContainsProperEJBClasses extends EjbTest implements EjbCheck { 



    /** 
     * ejb-jar file must contain the java class file of the enterprise bean 
     * implementation class, and any of the classes that it depends on.
     *  
     * @param descriptor the Enterprise Java Bean deployment descriptor 
     *
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	try {
	    Context context = getVerifierContext();
        Class c = Class.forName(descriptor.getEjbClassName(), false,
                             getVerifierContext().getClassLoader());
            // if we are dealing with a CMP2 entity bean, the class is abstract..
            if (descriptor instanceof EjbEntityDescriptor) {
	        String persistentType =
		    ((EjbEntityDescriptor)descriptor).getPersistenceType();
	        if (EjbEntityDescriptor.CONTAINER_PERSISTENCE.equals(persistentType)) {
                    if (EjbCMPEntityDescriptor.CMP_1_1!=((EjbCMPEntityDescriptor) descriptor).getCMPVersion()) {
			result.addGoodDetails(smh.getLocalString
					      ("tests.componentNameConstructor",
					       "For [ {0} ]",
					       new Object[] {compName.toString()}));

		        result.passed(smh.getLocalString
				      (getClass().getName() + ".passed",
				       "Bean class [ {0} ] exists and it's supporting classes exist.",
				       new Object[] {descriptor.getEjbClassName()}));
        	        return result;
                    }
                }
            }

            try {
		c.newInstance();
		result.addGoodDetails(smh.getLocalString
				      ("tests.componentNameConstructor",
				       "For [ {0} ]",
				       new Object[] {compName.toString()}));

		result.passed(smh.getLocalString
			      (getClass().getName() + ".passed",
			       "Bean class [ {0} ] exists and it's supporting classes exist.",
			       new Object[] {descriptor.getEjbClassName()}));
	    } catch (InstantiationException e) {
		Verifier.debug(e);
		result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));

		result.failed(smh.getLocalString
			      (getClass().getName() + ".failedException",
			       "Error: Could not instantiate [ {0} ] within bean [ {1} ]",
			       new Object[] {descriptor.getEjbClassName(),descriptor.getName()}));
	    } catch (IllegalAccessException e) {
		Verifier.debug(e);
		result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));

		result.failed(smh.getLocalString
			      (getClass().getName() + ".failedException1",
			       "Error: Illegal Access while trying to instantiate [ {0} ] within bean [ {1} ]",
			       new Object[] {descriptor.getEjbClassName(),descriptor.getName()}));
	    }
	} catch (ClassNotFoundException e) {
	    Verifier.debug(e);
	    result.addErrorDetails(smh.getLocalString
				   ("tests.componentNameConstructor",
				    "For [ {0} ]",
				    new Object[] {compName.toString()}));
	    
	    result.failed(smh.getLocalString
			  (getClass().getName() + ".failedException2",
			   "Error: Can't find class [ {0} ] within bean [ {1} ]",
			   new Object[] {descriptor.getEjbClassName(),descriptor.getName()}));
        } catch (Throwable t) {
	    Verifier.debug(t);
	    result.addNaDetails(smh.getLocalString
				("tests.componentNameConstructor",
				 "For [ {0} ]",
				 new Object[] {compName.toString()}));
	    
            result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "Not Applicable: [ {0} ] class encountered [ {1} ]. Cannot create instance of class [ {2} ] becuase [ {3} ] is not accessible within [ {4} ].",
				  new Object[] {(descriptor).getEjbClassName(),t.toString(), descriptor.getEjbClassName(), t.getMessage(), descriptor.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri()}));
	}
	return result;
    }
}
