/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.deployment.MethodDescriptor;
import java.util.*;

/** 
 * Session Bean transaction demarcation type for all methods of remote 
 * interface test.  
 * The transaction attributes must be specified for the methods defined
 * in the bean's remote interface and all the direct and indirect 
 * superinterfaces of the remote interface, excluding the methods of
 * the javax.ejb.EJBObject interface.
 */
public class MethodPermissionComponentInterface extends EjbTest implements EjbCheck { 
    Result result  = null;
    
    /** 
     * All methods should have a 
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {
        
        result = getInitializedResult();
//        boolean oneFailed = false;
        
        try  {
            if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
                
                Set methods = descriptor.getMethodDescriptors();
//		 Set methodPermissions = new HashSet();
                boolean noPermissions = false;
                
                for (Iterator i = methods.iterator(); i.hasNext();) {
                    MethodDescriptor md = (MethodDescriptor) i.next();
                    Set permissions = descriptor.getMethodPermissionsFor(md);
                    if (permissions.isEmpty() || (permissions == null)) {
                        result.addWarningDetails(smh.getLocalString
                                (getClass().getName() + ".failed",
                                        "Warning: Method [ {0} ] of EJB [ {1} ] does not have assigned security-permissions",
                                        new Object[] {md.getName(), descriptor.getName()}));
                        result.setStatus(result.WARNING);
                        noPermissions = true;
                    } 
                }
                
                if (!noPermissions) {
                    result.passed(smh.getLocalString
                            (getClass().getName() + ".passed",
                                    "Valid: All [ {0} ]EJB  interfaces methods have security-permissions assigned.",
                                    new Object[] {descriptor.getName()}));
                }
                
            } else {
                result.notApplicable(smh.getLocalString(
                        getClass().getName() + ".notApplicable", 
                        "The bean [ {0} ] is neither a Session nor Entity Bean",
                        new Object[] {descriptor.getName()}));
                return result;
            }
        } catch (Exception e) {
            result.failed(smh.getLocalString(
                    getClass().getName() + ".exception", 
                    "The test generated the following exception [ {0} ]",
                    new Object[] {e.getLocalizedMessage()}));
        }
        return result;
    }
    
}
