/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.security.acl.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

/**
 * The role-name element must conform to the lexical rules for an NMTOKEN
 */
public class RoleNameNMTOKEN extends EjbTest implements EjbCheck { 



    /** 
     * The role-name element must conform to the lexical rules for an NMTOKEN
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	if (!descriptor.getPermissionedRoles().isEmpty()) {
	    for (Iterator itr = descriptor.getPermissionedRoles().iterator();
		 itr.hasNext();) {

		Role nextRole = (Role) itr.next();
		if (NameToken.isNMTOKEN(nextRole.getName()))  {
		    result.addGoodDetails(smh.getLocalString
					  ("tests.componentNameConstructor",
					   "For [ {0} ]",
					   new Object[] {compName.toString()}));
		    result.addGoodDetails
			(smh.getLocalString
			 (getClass().getName() + ".passed",
			  "Role name [ {0} ] conforms to the lexical rules of NMTOKEN within bean [ {1} ]",
			  new Object[] {nextRole.getName(), descriptor.getName()}));
		    if (result.getStatus()!= Result.FAILED)
			result.setStatus(Result.PASSED);
		} else {
		    result.addErrorDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));
		    result.failed
			(smh.getLocalString
			 (getClass().getName() + ".failed",
			  "Role name [ {0} ] does not conform to the lexical rules of NMTOKEN within bean [ {1} ]",
			  new Object[] {nextRole.getName(), descriptor.getName()}));
		}
	    } 
	} else {
	    result.addNaDetails(smh.getLocalString
				("tests.componentNameConstructor",
				 "For [ {0} ]",
				 new Object[] {compName.toString()}));
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "No permissioned roles defined for this bean [ {0} ]",
				  new Object[] {descriptor.getName()}));
	} 
	return result;
    }
}
