/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;
/** 
 * Security role references test.
 * The Bean provider must declare all of the enterprise's bean references 
 * to security roles as specified in section 15.2.1.3 of the Moscone spec.
 * Role names must be mapped to names within the jar.
 */
public class SecurityRolesRefs extends EjbTest implements EjbCheck { 


    /** 
     * Security role references test.
     * The Bean provider must declare all of the enterprise's bean references
     * to security roles as specified in section 15.2.1.3 of the Moscone spec.
     * Role names must be mapped to names within the jar.
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
	if ((descriptor instanceof EjbEntityDescriptor) ||
	    (descriptor instanceof EjbSessionDescriptor)) {
        
	    // RULE: Role names must be mapped to names within the ejb-jar
	    Set roleReferences = descriptor.getRoleReferences();
	    Iterator roleRefsIterator = roleReferences.iterator();
	    EjbBundleDescriptor bundleDescriptor = descriptor.getEjbBundleDescriptor();
	    Set roles = bundleDescriptor.getRoles();
	    Iterator roleIterator = roles.iterator();
	    Role role = null;
	    RoleReference roleReference = null;
	    boolean found = false;
	    boolean oneFailed = false;
      
	    if (roleRefsIterator.hasNext()) {
		while (roleRefsIterator.hasNext()) {
		    found = false;
		    roleReference = (RoleReference)roleRefsIterator.next();

		    while (roleIterator.hasNext()) {
			role = (Role)roleIterator.next();
			if (role.getName().equals(roleReference.getValue())) {
			    found = true;
			    //reset this so next time it drop back into here
			    roleIterator = roles.iterator();
			    break;
			}
		    }

		    if (!found) {
			// print the roleReference with no corresponding env-prop
			result.addErrorDetails(smh.getLocalString
				   ("tests.componentNameConstructor",
				    "For [ {0} ]",
				    new Object[] {compName.toString()}));
			result.addErrorDetails(smh.getLocalString
					       (getClass().getName() + ".failed",
						"Erro: The security role reference [ {0} ] has no corresponding linked security role name [ {1} ]",
						new Object[] {roleReference.getName(),roleReference.getValue()}));
			if (!oneFailed) {
			    oneFailed = true;
			}
		    } else {      
			result.addGoodDetails(smh.getLocalString
				   ("tests.componentNameConstructor",
				    "For [ {0} ]",
				    new Object[] {compName.toString()}));
			result.addGoodDetails(smh.getLocalString
					      (getClass().getName() + ".passed",
					       "The security role reference [ {0} ] has corresponding linked security role name [ {1} ]",
					       new Object[] {roleReference.getName(),roleReference.getValue()}));
		    }
		}
	    } else { 
		result.addNaDetails(smh.getLocalString
				   ("tests.componentNameConstructor",
				    "For [ {0} ]",
				    new Object[] {compName.toString()}));
		result.notApplicable(smh.getLocalString
				     (getClass().getName() + ".notApplicable1",
				      "There are no role references within this bean [ {0} ]",
				      new Object[] {descriptor.getName()}));
		return result;
	    }

	    // if one of 'em failed reset the status appropriately, in case
	    // status got stomped on within the while loop by the next env-prop
	    if (oneFailed) {
		result.setStatus(Result.FAILED);
	    } else {
		result.setStatus(Result.PASSED);
	    }

	    return result;
	} else {
	    result.addNaDetails(smh.getLocalString
				   ("tests.componentNameConstructor",
				    "For [ {0} ]",
				    new Object[] {compName.toString()}));
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "[ {0} ] not called \n with a Session or Entity bean.",
				  new Object[] {getClass()}));
	    return result;
	}
    }
}
