/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.ejb.ejb30;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.deployment.EjbDescriptor;

import java.lang.reflect.Method;
import java.util.Set;

/**
 * The methods of the business interface may declare arbitrary application 
 * exceptions. However, the methods of the business interface should not throw 
 * the java.rmi.RemoteException, even if the interface is a remote business 
 * interface or the bean class is annotated WebService or the method as 
 * WebMethod.
 * The methods of the business interface may only throw the 
 * java.rmi.RemoteException if the interface extends java.rmi.Remote.
 * 
 * @author Vikas Awasthi
 */
public class BusinessInterfaceException extends EjbTest {

    public Result check(EjbDescriptor descriptor) {
        Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        
        Set<String> localAndRemoteClassNames = descriptor.getLocalBusinessClassNames();
        localAndRemoteClassNames.addAll(descriptor.getRemoteBusinessClassNames());
        
        for (String localOrRemoteClass : localAndRemoteClassNames) 
            checkForRemoteException(localOrRemoteClass,result,compName);

        if(result.getStatus() != Result.WARNING) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                            (getClass().getName() + ".passed",
                            "Business interface(s) if any are valid."));
        }
        return result;
    }
    
    private void checkForRemoteException(String className, 
                                        Result result, 
                                        ComponentNameConstructor compName) {
        try {
            Class c = Class.forName(className, 
                                    false, 
                                    getVerifierContext().getClassLoader());
            // do not check further if the business interface extends java.rmi.Remote 
            if(java.rmi.Remote.class.isAssignableFrom(c))
                return;
            Method[] methods = c.getMethods();
            for (Method method : methods) {
                Class[] exceptions = method.getExceptionTypes();
                for (Class exception : exceptions) {
                    if(java.rmi.RemoteException.class.isAssignableFrom(exception)) {
                        addWarningDetails(result, compName);
                        result.warning(smh.getLocalString
                                        (getClass().getName() + ".warning",
                                        "java.rmi.RemoteException is thrown " +
                                        "in method [ {0} ] of business interface [ {1} ]",
                                        new Object[] {method.getName(), className}));
                    }
                }
            }
        } catch (ClassNotFoundException e) {
            Verifier.debug(e);
            addErrorDetails(result, compName);
            result.failed(smh.getLocalString
                            (getClass().getName() + ".failed1",
                            "[ {0} ] not found.",
                            new Object[] {className}));
        }
    }
}
