/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.ejb30;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;

import java.lang.reflect.Method;

/**
 * If the stateless session bean instance has an ejbCreate method, the container
 * treats the ejbCreate method as the instance’s PostConstruct method, and, in
 * this case, the PostConstruct annotation (or deployment descriptor metadata)
 * can only be applied to the bean’s ejbCreate method.
 * 
 * @author Vikas Awasthi
 */
public class EJBCreatePostConstruct extends SessionBeanTest {

    public Result check(EjbSessionDescriptor descriptor) {

        if(descriptor.isStateless() && 
                descriptor.hasPostConstructMethod() && 
                hasEJBCreateMethod(descriptor.getEjbClassName())) {
            for (LifecycleCallbackDescriptor callbackDesc : 
                    descriptor.getPostConstructDescriptors()) {
                String cmName = callbackDesc.getLifecycleCallbackMethod();
                if(!cmName.contains("ejbCreate")) {
                    addErrorDetails(result, compName);
                    result.failed(smh.getLocalString
                            (getClass().getName()+".failed",
                                    "Wrong postconstruct method [ {0} ]",
                                    new Object[] {cmName}));
                }
            }
        }
        
        if(result.getStatus() != Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                            (getClass().getName()+".passed",
                            "Valid postcontruct method(s) in Bean"));
        }
        
        return result;
    }
    
    private boolean hasEJBCreateMethod(String beanClassName) {
        try {
            ClassLoader jcl = getVerifierContext().getClassLoader();
            Class bean = Class.forName(beanClassName, false, jcl);
            Method[] methods = bean.getMethods();
            for (Method method : methods) 
                if(method.getName().contains("ejbCreate"))
                    return true;
        } catch (ClassNotFoundException e) {}// will be caught in other tests
        return false;
    }
}
