/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
package com.sun.enterprise.tools.verifier.tests.ejb.ejb30;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.EjbInitInfo;

import java.util.Set;
import java.lang.reflect.Method;

/**
 * The Init annotation is used to specify the correspondence of a method on the 
 * bean class with a createMETHOD method for an adapted EJB 2.1 EJBHome and/or 
 * EJBLocalHome client view. 
 * The result type of such an Init method is required to be void.
 * 
 * @author Vikas Awasthi
 */
public class InitMethodReturnType extends SessionBeanTest {

    public Result check(EjbSessionDescriptor descriptor) {
        Set<EjbInitInfo> initMethods = descriptor.getInitMethods();
        for (EjbInitInfo initInfo : initMethods) {
            Method method = initInfo.getBeanMethod().getMethod(descriptor);
            if(!method.getReturnType().getName().equals("void")) {
                addErrorDetails(result, compName);
                result.failed(smh.getLocalString
                        (getClass().getName()+".failed",
                        "Wrong init method [ {0} ].",
                        new Object[] {method}));
            }
        }
        
        if(result.getStatus() != Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                    (getClass().getName()+".passed",
                    "Valid init method(s)."));
        }
        return result;
    }
}
