/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.*;

/** 
 * The abstract schema name for every CMP bean within a jar file should be unique.
 *
 * @author Sheetal Vartak
 *
 */
public class UniqueAbstractSchemaName extends EjbTest implements EjbCheck { 


    /** 
     * The abstract schema name for every CMP bean within a jar file should be unique.
     *
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
	boolean oneFailed = false;
	String abstractSchema = null;

	if (descriptor instanceof EjbEntityDescriptor) {
	    if (((EjbEntityDescriptor)descriptor).getPersistenceType().equals(EjbEntityDescriptor.CONTAINER_PERSISTENCE)) {                
                
                if (((EjbCMPEntityDescriptor) descriptor).getCMPVersion()==EjbCMPEntityDescriptor.CMP_2_x) {
                    abstractSchema = ((EjbCMPEntityDescriptor)descriptor).getAbstractSchemaName();
                    if (abstractSchema==null) {
                        result.addErrorDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));
                        result.failed(smh.getLocalString
                                        (getClass().getName() + ".failed2",
                                        "No Abstract Schema Name specified for a CMP 2.0 Entity Bean {0} ",
                                        new Object[] {descriptor.getName()}));                          
                        return result;
                    }
                }
            }
            if (abstractSchema ==null) {
                result.addNaDetails(smh.getLocalString
                    ("tests.componentNameConstructor",
                    "For [ {0} ]",
                    new Object[] {compName.toString()}));
                result.notApplicable(smh.getLocalString
                    (getClass().getName() + ".notApplicable",
                    "This test is only for CMP 2.0 beans. Abstract Schema Names should be unique within an ejb JAR file."));
                    return result;
	    }

	    EjbBundleDescriptor bundle = descriptor.getEjbBundleDescriptor();
	    Iterator iterator = (bundle.getEjbs()).iterator();
	    Vector<String> schemaNames = new Vector<String>();
	    while(iterator.hasNext()) {
		EjbDescriptor entity = (EjbDescriptor) iterator.next();
		if (entity instanceof EjbEntityDescriptor) { 
		    if (!entity.equals(descriptor)) {
			if (((EjbEntityDescriptor)entity).getPersistenceType().equals(EjbEntityDescriptor.CONTAINER_PERSISTENCE)) {
			    schemaNames.addElement(((EjbCMPEntityDescriptor)entity).getAbstractSchemaName());
			} 
		    }
		}
	    }

	    for (int i = 0; i < schemaNames.size(); i++) {
		if (abstractSchema.equals(schemaNames.elementAt(i))) {
		    result.addErrorDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));
		    result.addErrorDetails
			(smh.getLocalString
			 (getClass().getName() + ".failed",
			  "Abstract Schema Names should be unique within an ejb JAR file. Abstract Schema Name [ {0} ] is not unique.",
			  new Object[] {abstractSchema}));
		    oneFailed = true;
		}
	    }
	    if (oneFailed == false) {
		result.addGoodDetails(smh.getLocalString
				      ("tests.componentNameConstructor",
				       "For [ {0} ]",
				       new Object[] {compName.toString()}));
		result.passed
		(smh.getLocalString
		 (getClass().getName() + ".passed",
		  "PASSED : Abstract Schema Names for all beans within the ejb JAR file are unique."));
	    }
	    else result.setStatus(Result.FAILED);
	    
	} else {
        addNaDetails(result, compName);        
        result.notApplicable(smh.getLocalString
            (getClass().getName() + ".notApplicable",
            "This test is only for CMP 2.0 beans. Abstract Schema Names should be unique within an ejb JAR file."));
    }
    return result;
    }
}
