/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
/*
 * SelectMethodTest.java
 *
 * Created on December 14, 2000, 4:36 PM
 */

package com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2;

import java.lang.reflect.Method;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.*;

/**
 *
 * @author  dochez
 * @version 
 */
abstract public class SelectMethodTest extends CMPTest {

    protected abstract boolean runIndividualSelectTest(Method m, EjbCMPEntityDescriptor descriptor, Result result);
    
    /** 
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbCMPEntityDescriptor descriptor) {
        
        boolean allIsWell = true;
        Result result = getInitializedResult();
	boolean found = false;        
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

        Class ejbClass = loadEjbClass(descriptor, result);
        if (ejbClass!=null) {
            Method[] methods = ejbClass.getDeclaredMethods();
	    if (methods != null) {
		for (int i=0;i<methods.length;i++) {
		    String methodName = methods[i].getName();
		    if (methodName.startsWith("ejbSelect")) {
			found = true;
			if (!runIndividualSelectTest(methods[i], (EjbCMPEntityDescriptor) descriptor, result))
			    allIsWell=false;
		    }
		}
		if (found == false) {
		    result.addNaDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		    result.notApplicable(smh.getLocalString
					  ("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.SelectMethodTest.nptApplicable",
					   "Not Applicable : No select methods found",
					   new Object[] {}));     
		}
        if (result.getStatus() != Result.NOT_APPLICABLE) {    
            if (allIsWell) 
                result.setStatus(Result.PASSED);
            else 
                result.setStatus(Result.FAILED);            
            }
        }
	}    
	return result;
    }    
}
