/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.ejbpostcreatemethod;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.ClassLoader;
import com.sun.enterprise.tools.verifier.tests.*;
import javax.ejb.EntityBean;
import java.lang.reflect.*;
import com.sun.enterprise.deployment.*;
import java.util.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;

/**  
 * Entity Bean's ejbPostCreate(...) methods test.
 * Each entity Bean class may define zero or more ejbPostCreate(...) methods. 
 * The number and signatures of a entity Bean's create methods are specific 
 * to each EJB class. The method signatures must follow these rules: 
 * 
 * The method name must be ejbPostCreate. 
 *
 * The methods arguments must be the same as the arguments of the 
 * matching ejbCreate(...) method. 
 * 
 */
public class EjbPostCreateMethodArgs extends EjbTest implements EjbCheck { 


    /** 
     * Entity Bean's ejbPostCreate(...) methods test.
     * Each entity Bean class may define zero or more ejbPostCreate(...) methods. 
     * The number and signatures of a entity Bean's create methods are specific 
     * to each EJB class. The method signatures must follow these rules: 
     * 
     * The method name must be ejbPostCreate. 
     *
     * The methods arguments must be the same as the arguments of the 
     * matching ejbCreate(...) method. 
     * 
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	if (descriptor instanceof EjbEntityDescriptor) {
	    boolean oneFailed = false;
	    int foundAtLeastOne = 0;
	    try {
		Context context = getVerifierContext();
		ClassLoader jcl = context.getClassLoader();
		Class c = Class.forName(descriptor.getEjbClassName(), false, getVerifierContext().getClassLoader());

		Class [] ejbPostCreateMethodParameterTypes;
		Class [] ejbCreateMethodParameterTypes;
		boolean signaturesMatch = false;
		boolean ejbCreateExists = false;

		Method [] methods = c.getDeclaredMethods();
		Vector<Method> createMethodSuffix = new Vector<Method>();
		for (int i = 0; i < methods.length; i++) {
		    // The method name must start with create. 
		    if (methods[i].getName().startsWith("ejbCreate")) {
			createMethodSuffix.addElement((Method)methods[i]);
			ejbCreateExists = true;
		    }
		}
		
                // start do while loop here....
                do {
		    for (int i = 0; i < methods.length; i++) {
			// reset flags from last time thru loop
			signaturesMatch = false;
			
			// The method name must be ejbPostCreate. 
			if (methods[i].getName().startsWith("ejbPostCreate")) {
			    foundAtLeastOne++;

			    String matchSuffix = methods[i].getName().substring(13);
			    for (int k = 0; k < createMethodSuffix.size(); k++) {
				if (matchSuffix.equals(((Method)createMethodSuffix.elementAt(k)).getName().substring(9))) {
				    ejbCreateMethodParameterTypes = ((Method)createMethodSuffix.elementAt(k)).getParameterTypes();
				    ejbPostCreateMethodParameterTypes = methods[i].getParameterTypes();
				    if (Arrays.equals(ejbCreateMethodParameterTypes,ejbPostCreateMethodParameterTypes)) {
					signaturesMatch = true;
					break;
				    }
				}
			    }
			    if (signaturesMatch) {
				result.addGoodDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
				result.addGoodDetails(smh.getLocalString
						      (getClass().getName() + ".debug1",
						       "For EJB Class [ {0} ] method [ {1} ]",
						       new Object[] {descriptor.getEjbClassName(),methods[i].getName()}));
				result.addGoodDetails(smh.getLocalString
						      (getClass().getName() + ".passed",
						       "[ {0} ] declares [ {1} ] method with parameters that match corresponding [ {2} ] method.",
						       new Object[] {descriptor.getEjbClassName(),methods[i].getName(), "ejbCreate<method>"}));
			    } else if (!signaturesMatch) {
				oneFailed = true;
				result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
				result.addErrorDetails(smh.getLocalString
						       (getClass().getName() + ".debug1",
							"For EJB Class [ {0} ] method [ {1} ]",
							new Object[] {descriptor.getEjbClassName(),methods[i].getName()}));
				result.addErrorDetails(smh.getLocalString
						       (getClass().getName() + ".failed",
							"Error: An [ {0} ] method was found, but [ {1} ] method parameters did not match any corresponding [ {2} ] method parameters.",
							new Object[] {methods[i].getName(),methods[i].getName(),"ejbCreate<method>"}));
				break;
			    } 
			}
		    }
		    if (oneFailed == true)
			break;
                } while (((c = c.getSuperclass()) != null) && (foundAtLeastOne == 0));
        
		if (ejbCreateExists == false) {
		    result.addNaDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		    result.notApplicable(smh.getLocalString
					 (getClass().getName() + ".notApplicable1",
					  "[ {0} ] does not declare any ejbPostCreate(...) methods.",
					  new Object[] {descriptor.getEjbClassName()}));
		}
		if (foundAtLeastOne == 0 && ejbCreateExists == true){
		    oneFailed=true;
		    result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		    result.failed(smh.getLocalString
				  (getClass().getName() + ".failedException1",
				   "Error: ejbPostCreate<Method> method corresponding to the ejbCreate<Method> method does not exist!",
				   new Object[] {}));
		    
		}
	    } catch (ClassNotFoundException e) {
		Verifier.debug(e);
		result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		result.failed(smh.getLocalString
			      (getClass().getName() + ".failedException",
			       "Error: [ {0} ] class not found.",
			       new Object[] {descriptor.getEjbClassName()}));
		oneFailed = true;
	    }  

	    if (oneFailed) {
		result.setStatus(result.FAILED);
            } else if (foundAtLeastOne == 0) {
                result.setStatus(result.NOT_APPLICABLE);
	    } else {
		result.setStatus(result.PASSED);
	    }

	    return result;
 
	} else {
	    result.addNaDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "[ {0} ] expected {1} bean, but called with {2} bean.",
				  new Object[] {getClass(),"Entity","Session"}));
	    return result;
	}
    }
}
