/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.ejb.messagebean;

import java.lang.reflect.Method;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.*;


/**
 * Verify that message beans implement the ejbCreate method with a void return
 * type
 *
 * @author  Jerome Dochez
 * @version 
 */
public class EjbCreateReturnType extends MessageBeanTest {

    /**
     * <p>
     * @return the name of the method on the message bean this test applies to
     * </p>
     */
    protected String getMethodName() {
        return "ejbCreate";
    }
    
    /** 
     * Run a verifier test against an individual declared message
     * drive bean component
     * 
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbMessageBeanDescriptor descriptor) {
        
        Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        Class mbc = loadMessageBeanClass(descriptor, result);
        if (mbc!=null) {
            Method m = getMethod(mbc, getMethodName(),null);
            if (m!=null) {
                String returnType = m.getReturnType().getName();
                if ("void".equalsIgnoreCase(returnType)) {
        	    result.addGoodDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));	
		    result.passed(smh.getLocalString
			  ("com.sun.enterprise.tools.verifier.tests.ejb.messagebean.EjbCreateReturnType.passed",
                            "Message-Drive bean [ {0} ] {1} implementation has a void return type",
			   new Object[] {(descriptor).getEjbClassName(),m.getName()}));                    
                } else {
                    result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		    result.failed(smh.getLocalString
			  ("com.sun.enterprise.tools.verifier.tests.ejb.messagebean.EjbCreateReturnType.failed",
                            "Error: Message-Drive bean [ {0} ] {1} return type is [ {1} ]",
			   new Object[] {(descriptor).getEjbClassName(), returnType}));                    
                }
            } else {
                result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		result.failed(smh.getLocalString
		    ("com.sun.enterprise.tools.verifier.tests.ejb.messagebean.EjbCreateExists.failed",
                    "Error: Message-Drive bean [ {0} ] does not implement an {1} with no arguments",
	            new Object[] {(descriptor).getEjbClassName(), getMethodName()}));                       
            }
        }         
        return result;
    }
}
