package com.sun.enterprise.tools.verifier.tests.ejb.runtime;

/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;

import com.sun.enterprise.deployment.RunAsIdentityDescriptor;

/** ejb [0,n]
 *    principal ?
 *        name [String]
 *
 * The principal tag defines a username on the platform
 * @author Irfan Ahmed
 */
public class ASEjbPrincipal extends EjbTest implements EjbCheck { 


    public Result check(EjbDescriptor descriptor) 
    {
	Result result = getInitializedResult();
        
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        
        boolean oneFailed = false;
        try{
            if (descriptor.getUsesCallerIdentity() == false){
                RunAsIdentityDescriptor runAsIdDesc = descriptor.getRunAsIdentity();
                if (runAsIdDesc != null){
                    String principal = runAsIdDesc.getPrincipal();
                    if (principal == null){
                        addNaDetails(result, compName);
                        result.notApplicable(smh.getLocalString(getClass().getName()+".notApplicable",
                        "NOT APPLICABLE [AS-EJB ejb] : principal element not defined"));
                    }else{
                        if(principal.length()==0){
                            addErrorDetails(result, compName);
                            result.failed(smh.getLocalString(getClass().getName()+".failed",
                            "FAILED [AS-EJB principal] : name cannot be an empty String"));
                        }else{
                            addGoodDetails(result, compName);
                            result.passed(smh.getLocalString(getClass().getName()+".passed",
                            "PASSED [AS-EJB principal] : name is {0}", new Object[]{principal}));
                        }
                    }
                }
            }else{
                addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(getClass().getName()+".notApplicable",
                    "NOT APPLICABLE [AS-EJB ejb] run-as Element is not defined"));
            }
        }catch(Exception ex){
            addErrorDetails(result, compName);
            result.addErrorDetails(smh.getLocalString
                 (getClass().getName() + ".notRun",
                  "NOT RUN [AS-EJB] : Could not create an SunEjbJar object"));
        }

        return result;
    }
}
