/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.ejb.runtime.cmpmapping;

import java.util.Collection;
import java.util.Iterator;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.deployment.IASEjbCMPEntityDescriptor;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.JDOCodeGenerator;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLException;

public class ASCmpMappingTest extends EjbTest implements EjbCheck {

    public Result check(EjbDescriptor descriptor)
    {
        Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        try {
            if (descriptor instanceof IASEjbCMPEntityDescriptor) {
                Collection col = null;
                if(getVerifierContext().getJDOException()!=null){
                    result.addErrorDetails(smh.getLocalString
                            ("tests.componentNameConstructor",
                                    "For [ {0} ]",
                                    new Object[] {compName.toString()}));
                    result.failed (smh.getLocalString(getClass().getName() + ".failed1",
                            "Error: Exception [ {0} ] while initializing JDOCodeGenerator. Please check your descriptors and mapping files for consistency ",
                            new Object[] {getVerifierContext().getJDOException().getMessage()}));

                    return result;
                }else{
                    try{
                        JDOCodeGenerator jdc= getVerifierContext().getJDOCodeGenerator();
                        col = jdc.validate((IASEjbCMPEntityDescriptor)descriptor);
                    }catch(Exception ex){
                        result.addErrorDetails(smh.getLocalString
                                ("tests.componentNameConstructor",
                                        "For [ {0} ]",
                                        new Object[] {compName.toString()}));
                        result.failed (smh.getLocalString(getClass().getName() + ".failed",
                                "Error: Exception [ {0} ] when calling JDOCodeGenerator.validate().",
                                new Object[] {ex.getMessage()}));
                        return result;
                    }
                }
                if (col.isEmpty()){
                    result.addGoodDetails(smh.getLocalString
                            ("tests.componentNameConstructor",
                                    "For [ {0} ]",
                                    new Object[] {compName.toString()}));
                    result.passed(smh.getLocalString(getClass().getName() + ".passed",
                            "The mappings for the cmp beans (if any) are correct."));
                }else {
                    // collect all the cmpmapping related errors
                    String allErrors = null;
                    Iterator it = col.iterator();
                    while (it.hasNext()) {
                        Exception e = (Exception)it.next();
                        if (!(e instanceof EJBQLException)) {
                            allErrors = e.getMessage() + "\n\n";
                        }
                    }
                    if (allErrors != null) {
                        result.addErrorDetails(smh.getLocalString
                                ("tests.componentNameConstructor",
                                        "For [ {0} ]",
                                        new Object[] {compName.toString()}));
                        result.failed(smh.getLocalString(getClass().getName() + ".parseError",
                                "Error: Entity bean [ {0} ] has the following error(s) [ {1} ]."
                                , new Object[] {descriptor.getEjbClassName(), "\n" + allErrors} ));
                    }
                    else {
                        result.addGoodDetails(smh.getLocalString
                                ("tests.componentNameConstructor",
                                        "For [ {0} ]",
                                        new Object[] {compName.toString()}));
                        result.passed(smh.getLocalString(getClass().getName() + ".passed",
                                "The mappings for the cmp beans (if any) are correct."));
                    }
                  }
            } else
            {
                result.addNaDetails(smh.getLocalString
                        ("tests.componentNameConstructor",
                                "For [ {0} ]",
                                new Object[] {compName.toString()}));
                result.notApplicable(smh.getLocalString(getClass().getName() + ".notApplicable",
                        "Not applicable: Test only applies to container managed EJBs"));
            }
        } catch(Exception e) {
            result.addErrorDetails(smh.getLocalString
                    ("tests.componentNameConstructor",
                            "For [ {0} ]",
                            new Object[] {compName.toString()}));
            result.failed (smh.getLocalString(getClass().getName() + ".failed",
                    "Error: Exception [ {0} ] when calling JDOCodeGenerator.validate().",
                    new Object[] {e.getMessage()}));
        }
        return result;
    }
}
