/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.*;


/** 
 * Session Bean's bean-managed transaction demarcation test.  
 *
 *  The enterprise bean with bean-managed transaction demarcation must 
 *  be a Session bean.
 */
public class TransactionTypeBeanManaged extends EjbTest implements EjbCheck { 


    /** 
     * Session Bean's bean-managed transaction demarcation test.  
     *
     *  The enterprise bean with bean-managed transaction demarcation must 
     *  be a Session bean.
     *     
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	String transactionType = descriptor.getTransactionType();
	if (EjbSessionDescriptor.BEAN_TRANSACTION_TYPE.equals(transactionType)) {
	    if (descriptor instanceof EjbSessionDescriptor) {
		result.addGoodDetails(smh.getLocalString
				      ("tests.componentNameConstructor",
				       "For [ {0} ]",
				       new Object[] {compName.toString()}));
		result.passed(smh.getLocalString
			      (getClass().getName() + ".passed",
			       "[ {0} ] is valid transactionType within Session bean [ {1} ]",
			       new Object[] {transactionType, descriptor.getName()}));
	    } else if (descriptor instanceof EjbEntityDescriptor) {
		result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		result.failed(smh.getLocalString
			      (getClass().getName() + ".failedException",
			       "Error: [ {0} ] is not valid transactionType within entity bean [ {1} ]",
			       new Object[] {transactionType, descriptor.getName()}));
	    } 
	    return result;
	} else if (EjbSessionDescriptor.CONTAINER_TRANSACTION_TYPE.equals(transactionType)) {
	    result.addNaDetails(smh.getLocalString
				("tests.componentNameConstructor",
				 "For [ {0} ]",
				 new Object[] {compName.toString()}));
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "Expected [ {0} ] transaction demarcation, but [ {1} ] bean has [ {2} ] transaction demarcation.",
				  new Object[] {EjbSessionDescriptor.BEAN_TRANSACTION_TYPE,descriptor.getName(),EjbSessionDescriptor.CONTAINER_TRANSACTION_TYPE}));
	    return result;
	} else {
	    result.addNaDetails(smh.getLocalString
				("tests.componentNameConstructor",
				 "For [ {0} ]",
				 new Object[] {compName.toString()}));
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "Expected [ {0} ] transaction demarcation, but [ {1} ] bean has [ {2} ] transaction demarcation.",
				  new Object[] {EjbSessionDescriptor.BEAN_TRANSACTION_TYPE,descriptor.getName(),transactionType}));
	    return result;
	} 
    }
}
