/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.tests.persistence;

import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;

/**
 * The names of classes specified in persistence.xml must be loadable.
 * TopLink simply ignores if class could not be loaded. So we need this test.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class ClassNotFound extends VerifierTest implements VerifierCheck {
    public Result check(Descriptor descriptor) {
        Result result = getInitializedResult();
        addErrorDetails(result, getVerifierContext().getComponentNameConstructor());
        result.setStatus(Result.PASSED);
        final PersistenceUnitDescriptor pu = PersistenceUnitDescriptor.class.cast(descriptor);
        for(String className : pu.getClasses()) {
            try {
                Class.forName(className, false, getVerifierContext().getClassLoader());
            } catch (ClassNotFoundException e) {
                result.failed(smh.getLocalString(getClass().getName() + "failed1",
                        "Class [ {0} ] could not be loaded", new Object[]{className}));
            } catch (NoClassDefFoundError e) {
                result.failed(smh.getLocalString(getClass().getName() + "failed2",
                        "Class [ {0} ] could not be loaded " +
                        "because a dependent class could not be loaded. See reason:\n [ {1} ]",
                        new Object[]{className,e.getMessage()}));
            }
        }
        return result;
    }
}
