/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.SingleThreadModel;

/**
 * Assertion
 *
 *  EntityManager should not be injected into a web application that uses multithread model.
 *  EntityManager is not thread safe, hence it should not be injected into a web application
 *  that uses multithreaded model.
 *
 * @author bshankar@sun.com
 */
public class EntityManagerInjection extends WebTest implements WebCheck  {
    
    final static String className = EntityManagerInjection.class.getName();
    
    public Result check(WebBundleDescriptor descriptor) {
        
        Result result = getInitializedResult();
        addWarningDetails(result,
                getVerifierContext().getComponentNameConstructor());
        result.setStatus(Result.PASSED); //default status is PASSED
        
        for(EntityManagerReferenceDescriptor emRefDesc : descriptor.getEntityManagerReferenceDescriptors()) {
            Set<InjectionTarget> injectionTargets = emRefDesc.getInjectionTargets();
            if(injectionTargets != null) {
                for(InjectionTarget it : injectionTargets) {
                    String itClassName = it.getClassName();
                    String errMsg = smh.getLocalString(className + ".warning",
                            "Found a persistence unit by name [ {0} ] injected into [ {1} ].",
                            new Object[]{emRefDesc.getUnitName(), itClassName});
                    try {
                        Class c = Class.forName(itClassName, false, getVerifierContext().getClassLoader());
                        if(!(Servlet.class.isAssignableFrom(c))) {
                            result.warning(errMsg);
                        } else if (!(SingleThreadModel.class.isAssignableFrom(c))) {
                            result.warning(errMsg);
                        }
                    } catch(Exception ex) {
                        result.warning(errMsg);
                    }
                }
            }
        }
        return result;
    }
    
}
