/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.*;

/** 
 * Filter class exists tests.
 * Verify that the Filter class exists inside the .war file and is loadable.
 * 
 * @author Jerome Dochez
 * @version 1.0
 */
public class FilterClassExists extends FilterClass implements WebCheck {

    /**
     * <p>
     * Run the verifier test against a declared individual filter class
     * </p>
     *
     * @param result is used to put the test results in
     * @param filterClass is the individual filter class object to test
     * @return true if the test pass
     */    

    protected boolean runIndividualFilterTest(Result result, Class filterClass) {

        if (filterClass != null) {
	  
	    result.addGoodDetails(smh.getLocalString
		(getClass().getName() + ".passed",
		 "Filter class [ {0} ] resides in the WEB-INF/classes or WEB-INF/lib directory.",
		  new Object[] {filterClass.getName()}));    
            return true;
        } else
            return false;
    }    

}
